﻿using System;
using PostitCore;
using PostitCommon;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace DeXGets
{
    public class LearnerContactDetails : BaseClass
    {
        public class LearnerContactDetails_Response
        {
            public Guid ExternalID;
            public string ParentalSalutation;
            public string ParentalAddressee;
            public Nullable<bool> IsMailingPoint;
            public Nullable<bool> ReceivesCorrespondance;
            public Nullable<bool> ReceivesSchoolReport;
            public List<cLearnerContactRelationships> LearnerContactRelationships;
            public BaseLookups LearnerContactRelationshipType;
            public List<Telephone> Telephones;
            public List<Email> Emails;
            public List<AddressRecords> Addresses;

        }
        public class Email
        {
            public Guid ExternalID;
            public string EmailAddress;
            public BaseLookups LocationType;
            public Nullable<bool> IsMainEmail;
            public Nullable<bool> UseForAutomatedMessages;
        }
        public class AddressRecords
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;
            public Address Address;
        }
        public class Address
        {
            public Guid ExternalID;
            public string Apartment;
            public string BuildingNumber;
            public string BuildingName;
            public string Street;
            public string District;
            public string Town;
            public string AdministrativeArea;
            public string Postcode;
            public string AddressIdentifier;
        }

        public class Telephone
        {
            public Guid ExternalID;
            public string TelephoneNumber;
            public BaseLookups LocationType;
            public Nullable<bool> UseForAutomatedMessages;
            public Nullable<bool> IsFirstPointOfContact;
        }
        public class cLearnerContactRelationships
        {
            public Guid ExternalID;
            public Nullable<bool> HasCourtOrder;
            public Nullable<bool> HasParentalResponsibility;
            public string Priority; // Possibly should be an int but it makes no difference in this case
            public BaseLookups LearnerContact;

        }

        /// <summary>
        /// Returns the set of contact contact basics
        /// </summary>
        /// <param name="token"></param>
        /// <param name="key"></param>
        /// <param name="httpClient"></param>
        /// <returns></returns>
        public Dictionary<Guid, LearnerContactDetails_Response> GetValues(string token, string key, HttpClient httpClient)
        {
            Dictionary<Guid, LearnerContactDetails_Response> values = new Dictionary<Guid, LearnerContactDetails_Response>();
            string URL_LearnerContactDetail = SetURL("Learner", "LearnerContactDetails?$expand=LearnerContactRelationships,Addresses,Emails,Telephones,Addresses");
            string resp = DoCall(URL_LearnerContactDetail, token, httpClient, key);
            ODataResponse<LearnerContactDetails_Response> learners = null;
            try
            {
                learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerContactDetails_Response>>(resp);
                foreach (LearnerContactDetails_Response s in learners.Value)
                {
                    values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(learners.NextLink))
                {
                    resp = DoCall(GetNextLink(learners.NextLink), token, httpClient, key);
                    learners = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<LearnerContactDetails_Response>>(resp);
                    foreach (LearnerContactDetails_Response s in learners.Value)
                    {
                        // to 'combat' the skip bug prior to fix 
                        if (!values.ContainsKey(s.ExternalID))
                        {
                            values.Add(s.ExternalID, s);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorMessage = "Error: " + resp;
            }
            return values;
        }
    }
}
